    NAME OsScreen

; This is Os.Screen.Asm.

CGROUP GROUP CODE

PUBLIC xCpScreenInfo


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP


;    xCpScreenInfo : PROCEDURE (pInfo) CLEAN;
;      DCL pInfo     PTR;
;      DCL info      BASED pInfo  ScreenInfoType;
;
;    This will return information about screen size, etc.

ScreenInfoType STRUC
  xPixels    DW ?
  yPixels    DW ?
  pScreenOff DW ?
  pScreenSeg DW ?
  bitsPerPel DB ?
  yAspect    DW ?
ScreenInfoType ENDS

screenInfo  EQU ES:[DI]
pScreenInfo  EQU DWORD PTR [BP+6]

xCpScreenInfo PROC FAR
  PUSH BP
  MOV  BP, SP

  LES  DI, pScreenInfo
  MOV  screenInfo.xPixels, 640
  MOV  screenInfo.yPixels, 200
  MOV  screenInfo.yAspect, 140
  MOV  screenInfo.pScreenSeg, 0B800h

  MOV  screenInfo.pScreenOff, 0
  MOV  screenInfo.bitsPerPel, 1

  POP  BP
  RET  4
xCpScreenInfo ENDP

PURGE screenInfo
PURGE pScreenInfo
PURGE ScreenInfoType
PURGE xPixels
PURGE yPixels
PURGE pScreenOff
PURGE pScreenSeg
PURGE bitsPerPel
PURGE yAspect

CODE ENDS

    END
